<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/settings/db.php';
require_once $_SERVER['DOCUMENT_ROOT'].'/system/settings/mercury.php';
require_once $_SERVER['DOCUMENT_ROOT'].'/system/includes/LoginCheck.php';


$settingsCheck = $DB->prepare("select * from settings where id=?");
$settingsCheck->execute(array('1'));
$settings = $settingsCheck->fetch(PDO::FETCH_ASSOC);
session_start();
$user_id = $_SESSION['memberId'];
$userCheckSite= $DB->prepare("select * from users where id=?");
$userCheckSite->execute(array($user_id));
$userChk = $userCheckSite->fetch(PDO::FETCH_ASSOC);

function id($text) {
    $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
    $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
    $text = strtolower(str_replace($find, $replace, $text));
    $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
    $text = trim(preg_replace('/\s+/', ' ', $text));
    $text = str_replace(' ', '', $text);

    return $text;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>

    <meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="keywords" content="<?=$settings["siteKeyword"]?>">
	<meta name="author" content="mercuryweb.net">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="<?=$settings["siteDesc"]?>">
	<meta property="og:title" content="<?=$settings["siteName"]?>">
	<meta property="og:description" content="<?=$settings["siteDesc"]?>">
	<meta name="format-detection" content="telephone=no">
	
	<!-- PAGE TITLE HERE -->
	<title><?=$settings["siteName"]?> - <?=$settings["siteDesc"]?></title>
	<!-- FAVICONS ICON -->
	<link rel="shortcut icon" type="image/png" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/images/logo/<?=$settings["siteLogo"]?>">

	<link href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
	<link rel="stylesheet" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/vendor/select2/css/select2.min.css">
	<link href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/vendor/swiper/css/swiper-bundle.min.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.4/nouislider.min.css">
	<link href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
	<link href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/vendor/jvmap/jquery-jvectormap.css" rel="stylesheet">
	<link href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css" rel="stylesheet">
	<link href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/vendor/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css" rel="stylesheet">
	<link href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/images/country/freakflags.css" rel="stylesheet">
	<!-- Style css -->
   <link href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/css/style.css" rel="stylesheet">
   <style>.feather-sun {
    color: white;
    opacity: 1;
}

.feather-icon-edit, .feather-icon-trash {
    width: 17px;
    height: 17px;
    margin-left: 1px;
    margin-bottom: 1.5px;
}

.feather-icon-right {
	margin-right: -5px;
}
.feather-icon-left {
	margin-left: -1px;
}
</style>
</head>
<body>


    <!--*******************
        Preloader start
    ********************-->
    <div id="preloader">
		<div class="lds-ripple">
			<div></div>
			<div></div>
		</div>
    </div>
    <!--*******************
        Preloader end
    ********************-->
    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">
        <!--**********************************
            Nav header start
        ***********************************-->
		<div class="nav-header">
    <a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/home" type="image/png" class="brand-logo">
        <img id="logo" src="https://<?php echo $_SERVER['SERVER_NAME']; ?>/assets/images/logo/<?php echo $settings["headerLogo"]; ?>" alt="Logo" width="160" height="35">
    </a>

    <div class="nav-control menu">
        <div class="hamburger" onclick="toggleMenu()">
            <span class="line"></span>
            <span class="line"></span>
            <span class="line"></span>
        </div>
    </div>
</div>



        <!--**********************************
            Nav header end
        ***********************************-->
		
		
		<!--**********************************
            Header start
        ***********************************-->
		<div class="header">
            <div class="header-content">
                <nav class="navbar navbar-expand">
                    <div class="collapse navbar-collapse justify-content-between">
                        <div class="header-left">
                        </div>
						
						





						
                            <ul class="navbar-nav header-right">
							

							<li class="nav-item dropdown">
    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <i class="ficon" style=" margin-bottom: -5px;" data-feather="globe"></i>
    </a>
    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
	<?php if($settings['langSystem']=='1'){ ?>
    <?php 
    $langs = $DB->query("SELECT * FROM languages ORDER BY id")->fetchAll(PDO::FETCH_ASSOC); 
    foreach ($langs as $langsCek) {
    ?>
    <a class="dropdown-item change-the-lang" href="#" data-lang="<?=$langsCek['code']?>" <?php if($language==$langsCek['code']){echo 'selected';} ?>>
        <span class="fflag  ff-md ff-round fflag-<?=$langsCek['code']?>"></span>
        <?=$langsCek['name']?>
    </a>
    <?php }?>
<?php } ?>



    </div>
</li>


                            <li class="nav-item dropdown">
							<a class="nav-link" onclick="toggleDarkMode()">
    <i id="switchmode" style=" margin-bottom: -5px;" class="ficon" data-feather="moon"></i>
</a></li>

							<li class="nav-item ps-3">
								<div class="dropdown header-profile2">
									<a class="nav-link" href="javascript:void(0);" role="button" data-bs-toggle="dropdown" aria-expanded="false">
										<div class="header-info2 d-flex align-items-center">
											<div class="header-media">
												<img src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/images/profile/<?php if(empty($userChk['photo'])){echo 'no-photo.png';}else{echo $userChk['photo'];} ?>" alt="">
											</div>
											
											<div class="header-info">
												<h6><?=$userChk['name']?></h6>
												<p><?php
if ($userChk['isAdmin'] == 1) {
    echo "Admin";
} else {
    if (isset($userChk['department']) && $userChk['department']) {
        $departmentId = $userChk['department'];
        
        $stmt = $DB->prepare("SELECT name FROM departments WHERE id = ?");
        $stmt->execute([$departmentId]);
        $department = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($department && isset($department['name'])) {
            echo $department['name'];
        } else {
            echo "Kullanıcı";
        }
    } else {
        echo "Kullanıcı";
    }
}
?>
</p>


											</div>
											
										</div>
									</a>
									<div class="dropdown-menu dropdown-menu-end" style="">
										<div class="card border-0 mb-0">
											<div class="card-header py-2">
												<div class="products">
											

													<img src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/images/profile/<?php if(empty($userChk['photo'])){echo 'no-photo.png';}else{echo $userChk['photo'];} ?>" class="avatar avatar-md" alt="">
													<div>
														<h6><?=$userChk['name']?></h6>
														<p><?php
if ($userChk['isAdmin'] == 1) {
    echo "Admin";
} else {
    if (isset($userChk['department']) && $userChk['department']) {
        $departmentId = $userChk['department'];
        
        $stmt = $DB->prepare("SELECT name FROM departments WHERE id = ?");
        $stmt->execute([$departmentId]);
        $department = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($department && isset($department['name'])) {
            echo $department['name'];
        } else {
            echo "Kullanıcı";
        }
    } else {
        echo "Kullanıcı";
    }
}
?>
</p>


													</div>	
												</div>
											</div>
											<div class="card-body px-0 py-2">
												<a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/profile-settings" class="dropdown-item ai-icon ">
												<i data-feather="user" class="feather-icon"></i>


													<span class="ms-2"><?=$translations["headerProfile"]?></span>
												</a>
									
												<a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/logout" class="dropdown-item ai-icon">
													<svg class="profle-logout" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#ff7979" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path><polyline points="16 17 21 12 16 7"></polyline><line x1="21" y1="12" x2="9" y2="12"></line></svg>
													<span class="ms-2 text-danger"><?=$translations["headerLogout"]?></span>
												</a>
											</div>
										</div>
										
									</div>
								</div>
							</li>
                        </ul>
                    </div>
				</nav>
			</div>
		</div>
        <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

        <!--**********************************
            Sidebar start
        ***********************************-->
		  <div class="deznav">
            <div class="deznav-scroll">
				<ul class="metismenu" id="menu">
			<?php if ($userChk['isAdmin'] == '1' || $userChk['porderAdd'] == '1' || $userChk['pcaseAdd'] == '1' || $userChk['pmemberAdd'] == '1' || $userChk['pcompanyAdd'] == '1' || $userChk['pnoteAdd'] == '1') { ?>
				<li><a class="has-arrow " href="javascript:void(0);" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="plus-square" class="feather-icon"></i>
						</div>	
						<span class="nav-text"><?=$translations["quickshortcut"]?></span>
						</a>
						<ul aria-expanded="false">
							<?php if ($userChk['porderAdd'] == '1' || $userChk['isAdmin'] == '1') { ?>
							<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/orders-add"><?=$translations["headerAddOrder"]?></a></li>
							<?php } ?>
							<?php if ($userChk['pcaseAdd'] == '1' || $userChk['isAdmin'] == '1') { ?>
							<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/case-add?type=1"><?=$translations["headerAddIncome"]?></a></li>
							<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/case-add?type=2"><?=$translations["headerAddExpense"]?></a></li>
							<?php } ?>
							<?php if ($userChk['pmemberAdd'] == '1' || $userChk['isAdmin'] == '1') { ?>
							<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/member-add"><?=$translations["headerAddMember"]?></a></li>
							<?php } ?>
							<?php if ($userChk['pcompanyAdd'] == '1' || $userChk['isAdmin'] == '1') { ?>
							<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/company-add"><?=$translations["headerAddCompany"]?></a></li>
							<?php } ?>
							<?php if ($userChk['pnoteAdd'] == '1' || $userChk['isAdmin'] == '1') { ?>
							<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/note-add"><?=$translations["headerAddNote"]?></a></li>
							<?php } ?>

							
						</ul><?php } ?>
					</li>

                <li class="menu-title"><?=$translations["headerSystem"]?></li>

					<li><a class="" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/home" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="home" class="feather-icon"></i>

						</div>	
						<span class="nav-text"><?=$translations["headerHomepage"]?></span>
						</a>
					</li>
					<?php if ($settings['orderSystem'] == '1') { ?>
					<?php if ($userChk['porderView'] == '1' || $userChk['isAdmin'] == '1') { ?>
                <li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/orders" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="shopping-cart" class="feather-icon"></i>
						</div>	
							<span class="nav-text"><?=$translations["headerOrders"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php } ?>
					<?php if ($settings['caseSystem'] == '1') { ?>
					<?php if ($userChk['pcaseView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/case" class="" aria-expanded="false">
					<div class="menu-icon">
					<i data-feather="credit-card" class="feather-icon"></i>
						</div>	
							<span class="nav-text"><?=$translations["headerCase"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php } ?>
					<?php if ($userChk['pproductView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/products" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="compass" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerProducts"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php if ($userChk['pmemberView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/members" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="users" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerMembers"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php if ($userChk['pnoteView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/notes" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="file-text" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerNotes"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php if ($userChk['pcompanyView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/companies" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="bookmark" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerCompanies"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php if ($userChk['pproviderView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/providers" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="user-plus" class="feather-icon"></i>
						</div>	
							<span class="nav-text"><?=$translations["headerProviders"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php if($userChk['isAdmin'] == '1'){ ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/users" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="user" class="feather-icon"></i>
						</div>	
							<span class="nav-text"><?=$translations["headerUsers"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php if($userChk['isAdmin'] == '1'){ ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/Check-Report" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="hash" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerReports"]?></span>
						</a>
					</li>
					<?php }?>
					<?php if ($userChk['psettingsView'] == '1' || $userChk['isAdmin'] == '1') { ?>
                    <li class="menu-title"><?=$translations["headerGeneralSettings"]?></li>
                    <li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/settings" class="" aria-expanded="false">
						<div class="menu-icon">
                        <i data-feather="settings" class="feather-icon"></i>
						</div>	
							<span class="nav-text"><?=$translations["headerSettings"]?></span>
						</a>
					</li>
					<?php }?>
					<?php if ($settings['langSystem'] == '1') { ?>
					<?php if ($userChk['plangView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/langs" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="globe" class="feather-icon"></i>
						</div>	
							<span class="nav-text"><?=$translations["headerLanguage"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php } ?>
					<?php if ($userChk['pdepartmentView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/departments" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="briefcase" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerDepartments"]?></span>
						</a>
					</li>
					<?php } ?>
					<?php if ($userChk['pcategoryView'] == '1' || $userChk['isAdmin'] == '1') { ?>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/category" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="command" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerCategory"]?></span>
						</a>
					</li>
					<?php } ?>
					<li class="menu-title"><?=$translations["headerProfileSettings"]?></li>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/profile-settings" class="" aria-expanded="false">
						<div class="menu-icon">
						<i data-feather="user" class="feather-icon"></i>

						</div>	
							<span class="nav-text"><?=$translations["headerProfile"]?></span>
						</a>
					</li>
					<li><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/logout" class="" aria-expanded="false">
						<div class="menu-icon">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ff7979" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path><polyline points="16 17 21 12 16 7"></polyline><line x1="21" y1="12" x2="9" y2="12"></line></svg>
						</div>	
						<span class="ms-2 text-danger"><?=$translations["headerLogout"]?></span>

						</a>
					</li>
					
			</div>
        </div>		
        <!--**********************************
            Sidebar end
        ***********************************-->

